/* --------------------------------------------------------------
  LanguageApi.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

import Ajax from '../libs/Ajax';

export default {
	/**
	 * Get StyleEdit UI Translations
	 *
	 * The success callback will contain an object with the translations.
	 *
	 * @param {String} languageCode The ISO code of the translation to be fetched.
	 *
	 * @return {jQuery.jqXHR}
	 */
	getTranslations(languageCode) {
		StyleEdit.Validator.isString(languageCode);
		const ajaxUrl = StyleEdit.Config.get('baseUrl') + '/api.php/languages/' + languageCode;
		return Ajax.get(ajaxUrl, {theme: StyleEdit.Config.get('theme') || undefined}, {dataType: 'json'});
	}
}
